/*
 * Decompiled with CFR 0.152.
 */
package tcintegrations.items.modifiers.armor;

import java.util.List;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.Nullable;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.armor.EquipmentChangeModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.EquipmentChangeContext;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import tcintegrations.items.TCIntegrationHooks;
import tcintegrations.items.modifiers.hooks.IArmorCrouchModifier;

public class FrontierCapModifier
extends Modifier
implements IArmorCrouchModifier,
EquipmentChangeModifierHook,
TooltipModifierHook {
    private static final UUID ATTRIBUTE_BONUS = UUID.fromString("0f65a587-22ee-4147-9dbe-79d88f078402");
    private static final float SPEED_FACTOR = 0.04f;

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addHook((Object)this, TCIntegrationHooks.CROUCH, ModifierHooks.EQUIPMENT_CHANGE, ModifierHooks.TOOLTIP);
    }

    @Override
    public void onCrouch(IToolStackView tool, int level, LivingEntity living) {
        if (tool.isBroken() || !living.m_20096_() || living.f_19853_.f_46443_) {
            return;
        }
        AttributeInstance attribute = living.m_21051_(Attributes.f_22279_);
        if (attribute == null) {
            return;
        }
        if (attribute.m_22111_(ATTRIBUTE_BONUS) != null) {
            attribute.m_22120_(ATTRIBUTE_BONUS);
        }
        if (!living.m_21255_()) {
            RandomSource rand = living.m_217043_();
            float boost = (float)level * 0.04f;
            attribute.m_22118_(new AttributeModifier(ATTRIBUTE_BONUS, "tcintegrations.modifier.frontiercap", (double)boost, AttributeModifier.Operation.ADDITION));
            if (rand.m_188501_() < 0.04f) {
                ToolDamageUtil.damageAnimated((IToolStackView)tool, (int)1, (LivingEntity)living, (EquipmentSlot)EquipmentSlot.HEAD);
            }
        }
    }

    @Override
    public void onStand(LivingEntity living) {
        AttributeInstance attribute = living.m_21051_(Attributes.f_22279_);
        if (attribute == null) {
            return;
        }
        if (attribute.m_22111_(ATTRIBUTE_BONUS) != null) {
            attribute.m_22120_(ATTRIBUTE_BONUS);
        }
    }

    public void onUnequip(IToolStackView tool, ModifierEntry modifier, EquipmentChangeContext context) {
        AttributeInstance attribute;
        IToolStackView newTool;
        LivingEntity livingEntity = context.getEntity();
        if (!livingEntity.f_19853_.f_46443_ && context.getChangedSlot() == EquipmentSlot.HEAD && ((newTool = context.getReplacementTool()) == null || newTool.isBroken() || (float)newTool.getModifierLevel((Modifier)this) != modifier.getEffectiveLevel()) && (attribute = livingEntity.m_21051_(Attributes.f_22279_)) != null && attribute.m_22111_(ATTRIBUTE_BONUS) != null) {
            attribute.m_22120_(ATTRIBUTE_BONUS);
        }
    }

    public void addTooltip(IToolStackView tool, ModifierEntry modifier, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        if (player == null || tooltipKey == TooltipKey.SHIFT || player.m_6047_() || player.m_6067_()) {
            TooltipModifierHook.addPercentBoost((Modifier)modifier.getModifier(), (Component)this.getDisplayName(), (double)(modifier.getEffectiveLevel() * 0.04f), tooltip);
        }
    }
}

